/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.php.internal.model.impl;

import com.aptana.editor.php.core.model.IMethod;
import com.aptana.editor.php.core.model.ISourceRange;
import com.aptana.editor.php.core.model.env.ModelElementInfo;
import com.aptana.editor.php.core.model.env.SourceMethodElementInfo;
import com.aptana.editor.php.indexer.IElementEntry;
import com.aptana.editor.php.internal.indexer.FunctionPHPEntryValue;
import com.aptana.editor.php.internal.model.impl.AbstractMember;
import com.aptana.editor.php.internal.model.impl.SourceRange;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class EntryBasedMethod
extends AbstractMember
implements IMethod {
    private FunctionPHPEntryValue entryValue;

    public EntryBasedMethod(IElementEntry methodEntry) {
        super(methodEntry);
        this.entryValue = (FunctionPHPEntryValue)methodEntry.getValue();
    }

    public List<String> getParameters() {
        Set<String> keys = this.entryValue.getParameters().keySet();
        if (keys == null || keys.size() == 0) {
            return Collections.emptyList();
        }
        ArrayList<String> result = new ArrayList<String>();
        result.addAll(keys);
        return result;
    }

    public int getFlags() {
        return this.entryValue.getModifiers();
    }

    public ISourceRange getNameRange() {
        return new SourceRange(this.entryValue.getStartOffset());
    }

    public int getElementType() {
        return 9;
    }

    public boolean isConstructor() {
        return false;
    }

    public List<String> getDirectParameterTypes() {
        Map<String, Set<Object>> paramsMap = this.entryValue.getParameters();
        ArrayList<String> result = new ArrayList<String>(paramsMap.size());
        for (Set<Object> paramTypes : paramsMap.values()) {
            if (paramTypes.size() != 1) continue;
            Object type = paramTypes.iterator().next();
            if (type != null && type instanceof String) {
                result.add((String)type);
                continue;
            }
            result.add(null);
        }
        return result;
    }

    public int getModifiers() {
        return this.entryValue.getModifiers();
    }

    @Override
    public ModelElementInfo getElementInfo() {
        List<String> directParameterTypes;
        SourceMethodElementInfo info = new SourceMethodElementInfo();
        info.setFlags(this.getFlags());
        info.setNameSourceStart(this.getSourceRange().getOffset());
        List<String> parameters = this.getParameters();
        if (parameters != null) {
            info.setArgumentNames(parameters.toArray(new String[parameters.size()]));
        }
        if ((directParameterTypes = this.getDirectParameterTypes()) != null) {
            info.setArgumentInializers(directParameterTypes.toArray(new String[directParameterTypes.size()]));
        }
        return info;
    }
}

